# -*- coding: utf-8 -*-
from datetime import datetime
from modules.kodi_utils import local_string as ls

years_movies = range(datetime.today().year, 1899, -1)

years_tvshows = range(datetime.today().year, 1941, -1)

decades_movies = [i for i in years_movies if not i % 10]

decades_tvshows = [i for i in years_tvshows if not i % 10] + ['1940']

oscar_winners = (
		(545611, 776503, 581734, 496243, 490132, 399055, 376867, 314365, 194662, 76203, 68734, 74643, 45269, 12162, 12405, 6977, 1422, 1640, 70, 122),
		(1574, 453, 98, 14, 1934, 597, 409, 197, 13, 424, 33, 274, 581, 403, 380, 746, 792, 606, 279, 11050),
		(783, 9443, 16619, 12102, 11778, 703, 1366, 510, 240, 9277, 238, 1051, 11202, 3116, 17917, 10633, 874, 15121, 11113, 5769),
		(947, 1725, 284, 665, 17281, 826, 2897, 15919, 654, 11426, 27191, 2769, 705, 25430, 23383, 33667, 887, 28580, 17661, 27367),
		(289, 43266, 223, 770, 34106, 43278, 43277, 12311, 3078, 56164, 33680, 42861, 143, 65203, 28966, 631)
	)

movie_certifications = (
		'G',
		'PG',
		'PG-13',
		'R',
		'NC-17',
		'NR'
	)

tvshow_certifications = (
		'tv-y',
		'tv-y7',
		'tv-g',
		'tv-pg',
		'tv-14',
		'tv-ma'
	)

languages = (
		(ls(32861), 'ar'), (ls(32862), 'bs'),   (ls(32863), 'bg'),   (ls(32864), 'zh'),   (ls(32865), 'hr'),   (ls(32866), 'nl'),   (ls(32867), 'en'),
		(ls(32868), 'fi'), (ls(32869), 'fr'),   (ls(32870), 'de'),   (ls(32871), 'el'),   (ls(32872), 'he'),   (ls(32873), 'hi'),   (ls(32874), 'hu'),
		(ls(32875), 'is'), (ls(32876), 'it'),   (ls(32877), 'ja'),   (ls(32878), 'ko'),   (ls(32879), 'mk'),   (ls(32880), 'no'),   (ls(32881), 'fa'),
		(ls(32882), 'pl'), (ls(32883), 'pt'),   (ls(32884), 'pa'),   (ls(32885), 'ro'),   (ls(32886), 'ru'),   (ls(32887), 'sr'),   (ls(32888), 'sl'),
		(ls(32889), 'es'), (ls(32890), 'sv'),   (ls(32891), 'tr'),   (ls(32892), 'uk')
	)
		

meta_languages = [
		{'iso': 'zh', 'name': 'Chinese'},          {'iso': 'hr', 'name': 'Croatian'},
		{'iso': 'cs', 'name': 'Czech'},            {'iso': 'da', 'name': 'Danish'},
		{'iso': 'nl', 'name': 'Dutch'},            {'iso': 'en', 'name': 'English'},
		{'iso': 'fi', 'name': 'Finnish'},          {'iso': 'fr', 'name': 'French'},
		{'iso': 'de', 'name': 'German'},           {'iso': 'el', 'name': 'Greek'},
		{'iso': 'he', 'name': 'Hebrew'},           {'iso': 'hu', 'name': 'Hungarian'},
		{'iso': 'it', 'name': 'Italian'},          {'iso': 'ja', 'name': 'Japanese'},
		{'iso': 'ko', 'name': 'Korean'},           {'iso': 'no', 'name': 'Norwegian'},
		{'iso': 'pl', 'name': 'Polish'},           {'iso': 'pt', 'name': 'Portuguese'},
		{'iso': 'ru', 'name': 'Russian'},          {'iso': 'sl', 'name': 'Slovenian'},
		{'iso': 'es', 'name': 'Spanish'},          {'iso': 'sv', 'name': 'Swedish'},
		{'iso': 'tr', 'name': 'Turkish'},          {'iso': 'ar-SA', 'name': 'Arabic Saudi Arabia'}
	]

regions = [
		{'code': 'AF', 'name': ls(32893)},   {'code': 'AL', 'name': ls(32894)},   {'code': 'DZ', 'name': ls(32895)},   {'code': 'AQ', 'name': ls(32896)},
		{'code': 'AR', 'name': ls(32897)},   {'code': 'AM', 'name': ls(32898)},   {'code': 'AU', 'name': ls(32899)},   {'code': 'AT', 'name': ls(32900)},
		{'code': 'BD', 'name': ls(32901)},   {'code': 'BY', 'name': ls(32902)},   {'code': 'BE', 'name': ls(32903)},   {'code': 'BR', 'name': ls(32904)},
		{'code': 'BG', 'name': ls(32905)},   {'code': 'KH', 'name': ls(32906)},   {'code': 'CA', 'name': ls(32907)},   {'code': 'CL', 'name': ls(32908)},
		{'code': 'CN', 'name': ls(32909)},   {'code': 'HR', 'name': ls(32910)},   {'code': 'CZ', 'name': ls(32911)},   {'code': 'DK', 'name': ls(32912)},
		{'code': 'EG', 'name': ls(32913)},   {'code': 'FI', 'name': ls(32914)},   {'code': 'FR', 'name': ls(32915)},   {'code': 'DE', 'name': ls(32916)},
		{'code': 'GR', 'name': ls(32917)},   {'code': 'HK', 'name': ls(32918)},   {'code': 'HU', 'name': ls(32919)},   {'code': 'IS', 'name': ls(32920)},
		{'code': 'IN', 'name': ls(32921)},   {'code': 'ID', 'name': ls(32922)},   {'code': 'IR', 'name': ls(32923)},   {'code': 'IQ', 'name': ls(32924)},
		{'code': 'IE', 'name': ls(32925)},   {'code': 'IL', 'name': ls(32926)},   {'code': 'IT', 'name': ls(32927)},   {'code': 'JP', 'name': ls(32928)},
		{'code': 'MY', 'name': ls(32929)},   {'code': 'NP', 'name': ls(32930)},   {'code': 'NL', 'name': ls(32931)},   {'code': 'NZ', 'name': ls(32932)},
		{'code': 'NO', 'name': ls(32933)},   {'code': 'PK', 'name': ls(32934)},   {'code': 'PY', 'name': ls(32935)},   {'code': 'PE', 'name': ls(32936)},
		{'code': 'PH', 'name': ls(32937)},   {'code': 'PL', 'name': ls(32938)},   {'code': 'PT', 'name': ls(32939)},   {'code': 'PR', 'name': ls(32940)},
		{'code': 'RO', 'name': ls(32941)},   {'code': 'RU', 'name': ls(32942)},   {'code': 'SA', 'name': ls(32943)},   {'code': 'RS', 'name': ls(32944)},
		{'code': 'SG', 'name': ls(32945)},   {'code': 'SK', 'name': ls(32946)},   {'code': 'SI', 'name': ls(32947)},   {'code': 'ZA', 'name': ls(32948)},
		{'code': 'ES', 'name': ls(32949)},   {'code': 'LK', 'name': ls(32950)},   {'code': 'SE', 'name': ls(32951)},   {'code': 'CH', 'name': ls(32952)},
		{'code': 'TH', 'name': ls(32953)},   {'code': 'TR', 'name': ls(32954)},   {'code': 'UA', 'name': ls(32955)},   {'code': 'AE', 'name': ls(32956)},
		{'code': 'GB', 'name': ls(32957)},   {'code': 'US', 'name': ls(32958)},   {'code': 'UY', 'name': ls(32959)},   {'code': 'VE', 'name': ls(32960)},
		{'code': 'VN', 'name': ls(32961)},   {'code': 'YE', 'name': ls(32962)},   {'code': 'ZW', 'name': ls(32963)}
	]

movie_genres = {
		ls(32548): ['28', 'genre_action'],                ls(32549): ['12', 'genre_adventure'],
		ls(32550): ['16', 'genre_animation'],             ls(32551): ['35', 'genre_comedy'],
		ls(32552): ['80', 'genre_crime'],                 ls(32553): ['99', 'genre_documentary'],
		ls(32554): ['18', 'genre_drama'],                 ls(32555): ['10751', 'genre_family'],
		ls(32558): ['14', 'genre_fantasy'],               ls(32559): ['36', 'genre_history'],
		ls(32560): ['27', 'genre_horror'],                ls(32561): ['10402', 'genre_music'],
		ls(32557): ['9648', 'genre_mystery'],             ls(32562): ['10749', 'genre_romance'],
		ls(32563): ['878', 'genre_scifi'],                ls(32564): ['10770', 'genre_soap'],
		ls(32565): ['53', 'genre_thriller'],              ls(32566): ['10752', 'genre_war'], 
		ls(32567): ['37', 'genre_western']
	}

tvshow_genres = {
		'%s & %s' % (ls(32548), ls(32549)): ['10759', 'genre_action'],         ls(32550): ['16', 'genre_animation'],
		ls(32551): ['35', 'genre_comedy'],                                     ls(32552): ['80', 'genre_crime'],
		ls(32553): ['99', 'genre_documentary'],                                ls(32554): ['18', 'genre_drama'],
		ls(32555): ['10751', 'genre_family'],                                  ls(32556): ['10762', 'genre_kids'],
		ls(32557): ['9648', 'genre_mystery'],                                  ls(32568):['10763', 'genre_news'],
		ls(32569): ['10764', 'genre_reality'],                                 ls(33057): ['10765', 'genre_scifi'],
		ls(32570): ['10766', 'genre_soap'],                                    ls(32570): ['10767', 'genre_talk'],
		ls(32572): ['10768', 'genre_war'],                                     ls(32567): ['37', 'genre_western']
	}

networks = (
		{'id':54,'name':'Disney Channel','logo': 'network_disney'},                   {'id':44,'name':'Disney XD','logo': 'network_disneyxd'},
		{'id':2,'name':'ABC','logo': 'network_abc'},                                  {'id':493,'name':'BBC America','logo': 'network_bbcamerica'},
		{'id':6,'name':'NBC','logo': 'network_nbc'},                                  {'id':13,'name':'Nickelodeon','logo': 'network_nickelodeon'},
		{'id':14,'name':'PBS','logo': 'network_pbs'},                                 {'id':16,'name':'CBS','logo': 'network_cbs'},
		{'id':19,'name':'FOX','logo': 'network_fox'},                                 {'id':21,'name':'The WB','logo': 'network_thewb'},
		{'id':24,'name':'BET','logo': 'network_bet'},                                 {'id':30,'name':'USA Network','logo': 'network_usanetwork'},
		{'id':23,'name':'CBC','logo': 'network_cbc'},                                 {'id': 88, 'name': 'FX', 'logo': 'network_fx'},
		{'id':33,'name':'MTV','logo': 'network_mtv'},                                 {'id':34,'name':'Lifetime','logo': 'network_lifetime'},
		{'id':35,'name':'Nick Junior','logo': 'network_nickjr'},                      {'id':41,'name':'TNT','logo': 'network_tnt'},
		{'id':43,'name':'National Geographic','logo': 'network_natgeo'},              {'id':47,'name':'Comedy Central','logo': 'network_comedycentral'},
		{'id':49,'name':'HBO','logo': 'network_hbo'},                                 {'id':55,'name':'Spike','logo': 'network_spike'},
		{'id':67,'name':'Showtime','logo': 'network_showtime'},                       {'id':56,'name':'Cartoon Network','logo': 'network_cartoonnetwork'},
		{'id':65,'name':'History Channel','logo': 'network_history'},                 {'id':84,'name':'TLC','logo': 'network_tlc'},
		{'id':68,'name':'TBS','logo': 'network_tbs'},                                 {'id':71,'name':'The CW','logo': 'network_thecw'},
		{'id':74,'name':'Bravo','logo': 'network_bravo'},                             {'id':76,'name':'E!','logo': 'network_e'},
		{'id':77,'name':'Syfy','logo': 'network_syfy'},                               {'id':80,'name':'Adult Swim','logo': 'network_adultswim'},
		{'id':91,'name':'Animal Planet','logo': 'network_animalplanet'},              {'id':110,'name':'CTV','logo': 'network_ctv'},
		{'id':129,'name':'A&E','logo': 'network_ane'},                                {'id':158,'name':'VH1','logo': 'network_vh1'},
		{'id':174,'name':'AMC','logo': 'network_amc'},                                {'id':928,'name':'Crackle','logo': 'network_crackle'},
		{'id':202,'name':'WGN America','logo': 'network_wgnamerica'},                 {'id':209,'name':'Travel Channel','logo': 'network_travel'},
		{'id':213, 'name':'Netflix','logo': 'network_netflix'},                       {'id':251,'name':'Audience','logo': 'network_audience'},
		{'id':270,'name':'SundanceTV','logo': 'network_sundancetv'},                  {'id':318,'name':'Starz','logo': 'network_starz'},
		{'id':359,'name':'Cinemax','logo': 'network_cinemax'},                        {'id':364,'name':'truTV','logo': 'network_trutv'},
		{'id':384,'name':'Hallmark Channel','logo': 'network_hallmark'},              {'id':397,'name':'TV Land','logo': 'network_tvland'},
		{'id':1024,'name':'Amazon','logo': 'network_amazon'},                         {'id':1267,'name':'Freeform','logo': 'network_freeform'},
		{'id':4,'name':'BBC 1','logo': 'network_bbc1'},                               {'id':332,'name':'BBC 2','logo': 'network_bbc2'},
		{'id':3,'name':'BBC 3','logo': 'network_bbc3'},                               {'id':100,'name':'BBC 4','logo': 'network_bbc4'},
		{'id':214,'name':'Sky 1','logo': 'network_sky1'},                             {'id':9,'name':'ITV','logo': 'network_itv'},
		{'id':26,'name':'Channel 4','logo': 'network_channel4'},                      {'id':99,'name':'Channel 5','logo': 'network_channel5'},
		{'id':136,'name':'E4','logo': 'network_e4'},                                  {'id':210,'name':'HGTV','logo': 'network_hgtv'},
		{'id':453,'name':'Hulu','logo': 'network_hulu'},                              {'id':1436,'name':'YouTube Red','logo': 'network_youtubered'},
		{'id':64,'name':'Discovery Channel','logo': 'network_discovery'},             {'id':2739,'name':'Disney+','logo': 'network_disneyplus'},
		{'id':2552,'name':'Apple TV +','logo': 'network_appletvplus'},                {'id':2697,'name':'Acorn TV','logo': 'network_acorntv'},
		{'id':1709,'name':'CBS All Access','logo': 'network_cbsallaccess'},           {'id':3186,'name':'HBO Max','logo': 'network_hbomax'},
		{'id':2243,'name':'DC Universe','logo': 'network_dcuniverse'},                {'id':2076,'name':'Paramount Network','logo': 'network_paramount'},
		{'id':4330,'name':'Paramount+','logo': 'network_paramountplus'},              {'id': 3353, 'name': 'Peacock', 'logo': 'network_peacock'},
		{'id':4353,'name':'Discovery+','logo': 'network_discoveryplus'}
	)

language_choices =  {
		'None': 'None',              'Afrikaans': 'afr',            'Albanian': 'alb',             'Arabic': 'ara',
		'Armenian': 'arm',         'Basque': 'baq',               'Bengali': 'ben',              'Bosnian': 'bos',
		'Breton': 'bre',           'Bulgarian': 'bul',            'Burmese': 'bur',              'Catalan': 'cat',
		'Chinese': 'chi',          'Croatian': 'hrv',             'Czech': 'cze',                'Danish': 'dan',
		'Dutch': 'dut',            'English': 'eng',              'Esperanto': 'epo',            'Estonian': 'est',
		'Finnish': 'fin',          'French': 'fre',               'Galician': 'glg',             'Georgian': 'geo',
		'German': 'ger',           'Greek': 'ell',                'Hebrew': 'heb',               'Hindi': 'hin',
		'Hungarian': 'hun',        'Icelandic': 'ice',            'Indonesian': 'ind',           'Italian': 'ita',
		'Japanese': 'jpn',         'Kazakh': 'kaz',               'Khmer': 'khm',                'Korean': 'kor',
		'Latvian': 'lav',          'Lithuanian': 'lit',           'Luxembourgish': 'ltz',        'Macedonian': 'mac',
		'Malay': 'may',            'Malayalam': 'mal',            'Manipuri': 'mni',             'Mongolian': 'mon',
		'Montenegrin': 'mne',      'Norwegian': 'nor',            'Occitan': 'oci',              'Persian': 'per',
		'Polish': 'pol',           'Portuguese': 'por',           'Portuguese(Brazil)': 'pob',   'Romanian': 'rum',
		'Russian': 'rus',          'Serbian': 'scc',              'Sinhalese': 'sin',            'Slovak': 'slo',
		'Slovenian': 'slv',        'Spanish': 'spa',              'Swahili': 'swa',              'Swedish': 'swe',
		'Syriac': 'syr',           'Tagalog': 'tgl',              'Tamil': 'tam',                'Telugu': 'tel',
		'Thai': 'tha',             'Turkish': 'tur',              'Ukrainian': 'ukr',            'Urdu': 'urd',
		'Vietnamese': 'vie'
	}

colors = [
		'FFFFFFE3', 'FFFFFAE6', 'FFFEF5E6', 'FFFEF0E5', 'FFFEEBE5', 'FFFFEFEF', 'FFFFE6EA', 'FFFFE6F1', 'FFFEE6F4', 'FFFFE6FB', 'FFFEE6FE', 'FFFAE6FF', 'FFF4E6FF',
		'FFF0E6FF', 'FFEAE7FC', 'FFE6E7FC', 'FFE6EBFF', 'FFE7F0FF', 'FFE7F5FF', 'FFE7FAFF', 'FFE6FFFF', 'FFE6FFFB', 'FFE7FEF4', 'FFE7FFF1', 'FFE6FFEA', 'FFE7FFE7',
		'FFEBFFF3', 'FFF1FFE6', 'FFF5FFE6', 'FFFBFFE6', 'FFFFFFFF', 'FFFFFFCB', 'FFFEFACA', 'FFFFEACB', 'FFFFE0CC', 'FFFED6CC', 'FFFFCACD', 'FFFFCCD5', 'FFFFCDE0',
		'FFFFCCEB', 'FFFFCBF5', 'FFFECCFD', 'FFF6CBFF', 'FFECCCFE', 'FFE0CCFF', 'FFD6CCFE', 'FFCCCCFE', 'FFCDD6FF', 'FFCAE1FF', 'FFCCEBFF', 'FFCEF4FD', 'FFCAFFFF',
		'FFCCFFF6', 'FFCBFEEB', 'FFCCFFE0', 'FFCCFFD6', 'FFCDFFCC', 'FFD7FFCB', 'FFE1FFCD', 'FFEBFFCC', 'FFF5FFCB', 'FFEFEFEF', 'FFFEFFB3', 'FFFFF1B2', 'FFFFE0B2',
		'FFFDD2B2', 'FFFFC2B3', 'FFFFB3B3', 'FFFFB2C2', 'FFFFB3D1', 'FFFFB3E1', 'FFFFB2F4', 'FFFFB3FE', 'FFF0B3FF', 'FFE1B2FF', 'FFD2B3FF', 'FFC1B3FE', 'FFB4B3FF',
		'FFB3C1FE', 'FFB2D1FF', 'FFB3E0FF', 'FFB2F0FF', 'FFB3FFFF', 'FFB3FFF0', 'FFB4FFE0', 'FFB3FFD1', 'FFB4FEC3', 'FFB3FFB4', 'FFC2FFB2', 'FFD1FFB4', 'FFE0FFB3',
		'FFF1FFB4', 'FFE0E0E0', 'FFFEFF99', 'FFFFEB9A', 'FFFED699', 'FFFFC299', 'FFFFAD98', 'FFFF9899', 'FFFF99AE', 'FFFF99C1', 'FFFE99D5', 'FFFF99EC', 'FFFF99FF',
		'FFEB99FF', 'FFD699FF', 'FFC299FF', 'FFAE99FF', 'FF9A99FF', 'FF98ADFE', 'FF9AC2FF', 'FF98D6FF', 'FF99EBFF', 'FF99FFFF', 'FF99FFEA', 'FF99FFD7', 'FF9AFFC3',
		'FF99FFAC', 'FF99FF99', 'FFADFF99', 'FFC2FF98', 'FFD6FF99', 'FFEAFF98', 'FFD0D0D0', 'FFFFFF80', 'FFFFE681', 'FFFFCC80', 'FFFFB381', 'FFFF9980', 'FFFE8081',
		'FFFF8199', 'FFFF80B3', 'FFFF80CD', 'FFFF80E7', 'FFFC81FE', 'FFE680FF', 'FFCC7FFF', 'FFB380FF', 'FF9980FF', 'FF807FFE', 'FF8099FE', 'FF7FB3FF', 'FF80CCFE',
		'FF80E6FF', 'FF7FFFFE', 'FF7FFEE0', 'FF80FFCC', 'FF80FFB2', 'FF80FF98', 'FF81FF81', 'FF99FF80', 'FFB3FF80', 'FFCCFF80', 'FFE6FF80', 'FFC0C0C0', 'FFFFFF6B',
		'FFFEE066', 'FFFFC267', 'FFFFA366', 'FFFF8566', 'FFFF6766', 'FFFF6685', 'FFFF66A4', 'FFFF66C1', 'FFFF66E0', 'FFFF66FF', 'FFE166FF', 'FFC366FF', 'FFA366FF',
		'FF8566FF', 'FF6665FE', 'FF6785FF', 'FF66A3FE', 'FF65C2FF', 'FF65E0FF', 'FF65FFFF', 'FF66FFE0', 'FF65FFC1', 'FF66FFA4', 'FF65FF85', 'FF66FF66', 'FF84FF66',
		'FFA2FF66', 'FFC2FF66', 'FFE0FF66', 'FFAFAFAF', 'FFFFFF4D', 'FFFFDB4E', 'FFFFB84E', 'FFFF944C', 'FFFF714D', 'FFFF4D4D', 'FFFF4D6F', 'FFFE4D93', 'FFFE4DB7',
		'FFFE4DDB', 'FFFF4DFF', 'FFDC4DFF', 'FFB84DFF', 'FF944EFF', 'FF704DFF', 'FF4D4CFF', 'FF4D70FE', 'FF4D94FE', 'FF4DB8FF', 'FF4DDBFF', 'FF4DFFFF', 'FF4DFFDB',
		'FF4EFFB9', 'FF4EFF95', 'FF4DFE70', 'FF4CFF4C', 'FF70FF4D', 'FF94FF4D', 'FFB8FE4D', 'FFDAFF4D', 'FF8C8C8C', 'FFFFFF33', 'FFFFD634', 'FFFFAD33', 'FFFF8532',
		'FFFF5C33', 'FFFF3334', 'FFFF335C', 'FFFF3287', 'FFFF33AE', 'FFFF33D6', 'FFFE33FF', 'FFD633FE', 'FFAD34FF', 'FF8534FF', 'FF5D33FF', 'FF3233FF', 'FF325CFE',
		'FF3285FF', 'FF33ADFF', 'FF33D6FF', 'FF33FFFE', 'FF32FFD6', 'FF34FFAD', 'FF33FF84', 'FF32FF5C', 'FF34FF33', 'FF5CFF34', 'FF85FE33', 'FFADFE33', 'FFD5FF33',
		'FF7C7C7C', 'FFFFFF19', 'FFFFD119', 'FFFFA418', 'FFFF751A', 'FFFF4719', 'FFFF1919', 'FFFF1947', 'FFFF1874', 'FFFF19A3', 'FFFF19D1', 'FFFF19FF', 'FFD019FF',
		'FFA219FF', 'FF751AFE', 'FF4719FF', 'FF1819FF', 'FF1947FF', 'FF1974FF', 'FF19A3FE', 'FF18D1FF', 'FF19FFFF', 'FF19FFD1', 'FF19FFA4', 'FF18FF75', 'FF19FF47',
		'FF19FF19', 'FF48FF19', 'FF76FF19', 'FFA3FE1A', 'FFD1FF19', 'FF6B6B6B', 'FFFFFF00', 'FFFFCC00', 'FFFE9900', 'FFFF6600', 'FFFF3300', 'FFFE0000', 'FFFE0032',
		'FFFF0066', 'FFFF0198', 'FFFF00CC', 'FFFF00FE', 'FFCC00FF', 'FF9A00FF', 'FF6601FF', 'FF3300FF', 'FF0000FE', 'FF0033FF', 'FF0166FF', 'FF0097FE', 'FF00CCFF',
		'FF00FFFF', 'FF01FFCD', 'FF00FF99', 'FF00FE67', 'FF00FF33', 'FF00FF01', 'FF33FF00', 'FF65FF00', 'FF99FE00', 'FFCCFF00', 'FF5D5D5D', 'FFE8E500', 'FFE6B800',
		'FFE68B00', 'FFE65C01', 'FFE72E00', 'FFE60000', 'FFE6002E', 'FFE6005B', 'FFE80183', 'FFE600B8', 'FFE600E6', 'FFB700E6', 'FF8900E6', 'FF5C01E5', 'FF2E00E6',
		'FF0000E6', 'FF012EE1', 'FF005BE7', 'FF008AE5', 'FF00B8E6', 'FF00E6E6', 'FF00E6B7', 'FF00E78B', 'FF00E65F', 'FF00E532', 'FF00E600', 'FF2FE600', 'FF5DE600',
		'FF8AE501', 'FFB8E600', 'FF4F4F4F', 'FFCDCC00', 'FFCDA301', 'FFCA7B02', 'FFCC5200', 'FFCC2900', 'FFCC0001', 'FFCD0029', 'FFCE0052', 'FFCC007B', 'FFCD00A3',
		'FFCB00CC', 'FFA300CB', 'FF7A01CC', 'FF5201CC', 'FF2A00D0', 'FF0000CC', 'FF0029CB', 'FF0052CC', 'FF007ACD', 'FF00A3CC', 'FF00CCCB', 'FF00CCA3', 'FF01CC7A',
		'FF03CB51', 'FF00CC29', 'FF01CC00', 'FF29CC01', 'FF52CB00', 'FF7ACB00', 'FFA2CC00', 'FF434343', 'FFB4B300', 'FFB38E00', 'FFB36B00', 'FFB34700', 'FFB32501',
		'FFB30101', 'FFB40025', 'FFB40047', 'FFB4006B', 'FFB5008B', 'FFB300B3', 'FF8F00B2', 'FF6B00B2', 'FF4700B4', 'FF2300B2', 'FF0000B2', 'FF0025B4', 'FF0047B3',
		'FF006BB3', 'FF008EB2', 'FF00B3B2', 'FF00B38E', 'FF00B36C', 'FF00B346', 'FF00B324', 'FF00B300', 'FF24B301', 'FF47B200', 'FF6CB201', 'FF90B301', 'FF373737',
		'FF999A00', 'FF987A00', 'FF995C01', 'FF9A3D00', 'FF9A1F00', 'FF990100', 'FF99001F', 'FF9A003E', 'FF99005B', 'FF9A007A', 'FF990099', 'FF7B0099', 'FF5D0099',
		'FF3D0099', 'FF1F0099', 'FF000098', 'FF011F99', 'FF003D98', 'FF005C99', 'FF007A99', 'FF009999', 'FF00997A', 'FF00995B', 'FF00993E', 'FF00991F', 'FF009900',
		'FF1E9900', 'FF3C9900', 'FF5C9900', 'FF7A9900', 'FF2E2E2E', 'FF7F8000', 'FF7F6601', 'FF804C00', 'FF803201', 'FF801A01', 'FF800000', 'FF800019', 'FF800033',
		'FF80004B', 'FF810065', 'FF81007F', 'FF660080', 'FF4C007F', 'FF33007F', 'FF1A0080', 'FF010080', 'FF011A7F', 'FF003480', 'FF004C80', 'FF00667F', 'FF008081',
		'FF008067', 'FF037F4B', 'FF008033', 'FF00801B', 'FF008001', 'FF1A8000', 'FF338000', 'FF4C8001', 'FF668100', 'FF242424', 'FF656600', 'FF675201', 'FF653D00',
		'FF672900', 'FF661400', 'FF660000', 'FF660015', 'FF660028', 'FF65003C', 'FF660053', 'FF660066', 'FF550069', 'FF3D0067', 'FF290066', 'FF150067', 'FF010066',
		'FF001465', 'FF012966', 'FF003D66', 'FF005267', 'FF006766', 'FF006651', 'FF00663E', 'FF01662A', 'FF006613', 'FF006600', 'FF146600', 'FF296600', 'FF3D6600',
		'FF516600', 'FF181818', 'FF4B4C00', 'FF4C3E01', 'FF4D2E00', 'FF4C1F00', 'FF4D0F00', 'FF4C0000', 'FF4C000F', 'FF4B001F', 'FF4C002E', 'FF4C003E', 'FF4C004B',
		'FF3D004D', 'FF2E004B', 'FF1F004C', 'FF0E004B', 'FF01004C', 'FF000E4B', 'FF001F4D', 'FF012E4D', 'FF003D4C', 'FF004C4C', 'FF004D3D', 'FF004C2E', 'FF004C1E',
		'FF004C0E', 'FF004C01', 'FF0F4C00', 'FF204C01', 'FF2D4C00', 'FF3E4C01', 'FF000000'
	]

media_lists = (
		"'tmdb_movies%'",
		"'tmdb_tv%'",
		"'tmdb_popular_people%'",
		"'tmdb_images_person%'",
		"'tmdb_media%'",
		"'tmdb_company%'",
		"'trakt_movies%'",
		"'trakt_tv%'",
		"'trakt_trending_user_lists%'",
		"'trakt_popular_user_lists%'",
		"'imdb_%'",
		"'tmdb_people%'",
		"'imdb_keyword%'",
		"'imdb_blunders%'",
		"'fen_discover%'",
		"'fen_FURK_T_FILE%'",
		"'fen_pm_instant_transfer%'",
		"'fen_rd_check_hash%'",
		"'FEN_AD_%'",
		"'FEN_RD_%'",
		"'FEN_FOLDER_%'",
		"'https%'"
	)

watch_providers = [
		{'name': 'Netflix', 'id': 8, 'logo': 'https://image.tmdb.org/t/p/original/t2yyOv40HZeVlLjYsCsPHnWLk4W.jpg', 'priority': 0},
		{'name': 'Amazon Prime Video', 'id': 9, 'logo': 'https://image.tmdb.org/t/p/original/emthp39XA2YScoYL1p0sdbAH2WA.jpg', 'priority': 1},
		{'name': 'Disney Plus', 'id': 337, 'logo': 'https://image.tmdb.org/t/p/original/7rwgEs15tFwyR9NPQ5vpzxTj19Q.jpg', 'priority': 1},
		{'name': 'Google Play Movies', 'id': 3, 'logo': 'https://image.tmdb.org/t/p/original/tbEdFQDwx5LEVr8WpSeXQSIirVq.jpg', 'priority': 3},
		{'name': 'Sun Nxt', 'id': 309, 'logo': 'https://image.tmdb.org/t/p/original/uW4dPCcbXaaFTyfL5HwhuDt5akK.jpg', 'priority': 3},
		{'name': 'Apple TV', 'id': 2, 'logo': 'https://image.tmdb.org/t/p/original/peURlLlr8jggOwK53fJ5wdQl05y.jpg', 'priority': 4},
		{'name': 'MUBI', 'id': 11, 'logo': 'https://image.tmdb.org/t/p/original/bVR4Z1LCHY7gidXAJF5pMa4QrDS.jpg', 'priority': 4},
		{'name': 'Apple TV Plus', 'id': 350, 'logo': 'https://image.tmdb.org/t/p/original/6uhKBfmtzFqOcLousHwZuzcrScK.jpg', 'priority': 5},
		{'name': 'fuboTV', 'id': 257, 'logo': 'https://image.tmdb.org/t/p/original/jPXksae158ukMLFhhlNvzsvaEyt.jpg', 'priority': 5},
		{'name': 'Classix', 'id': 445, 'logo': 'https://image.tmdb.org/t/p/original/iaMw6nOyxUzXSacrLQ0Au6CfZkc.jpg', 'priority': 5},
		{'name': 'Hulu', 'id': 15, 'logo': 'https://image.tmdb.org/t/p/original/zxrVdFjIjLqkfnwyghnfywTn3Lh.jpg', 'priority': 6},
		{'name': 'Curiosity Stream', 'id': 190, 'logo': 'https://image.tmdb.org/t/p/original/67Ee4E6qOkQGHeUTArdJ1qRxzR2.jpg', 'priority': 6},
		{'name': 'Paramount Plus', 'id': 531, 'logo': 'https://image.tmdb.org/t/p/original/xbhHHa1YgtpwhC8lb1NQ3ACVcLd.jpg', 'priority': 7},
		{'name': 'GuideDoc', 'id': 100, 'logo': 'https://image.tmdb.org/t/p/original/iX0pvJ2GFATbVIH5IHMwG0ffIdV.jpg', 'priority': 7},
		{'name': 'Public Domain Movies', 'id': 638, 'logo': 'https://image.tmdb.org/t/p/original/liEIj6CkvojVDiMWeexGvflSPZT.jpg', 'priority': 7},
		{'name': 'HBO Max', 'id': 384, 'logo': 'https://image.tmdb.org/t/p/original/Ajqyt5aNxNGjmF9uOfxArGrdf3X.jpg', 'priority': 8},
		{'name': 'Netflix Kids', 'id': 175, 'logo': 'https://image.tmdb.org/t/p/original/j2OLGxyy0gKbPVI0DYFI2hJxP6y.jpg', 'priority': 8},
		{'name': 'Eventive', 'id': 677, 'logo': 'https://image.tmdb.org/t/p/original/fadQYOyKL0tqfyj012nYJxm3N2I.jpg', 'priority': 8},
		{'name': 'HBO Max Amazon Channel', 'id': 1825, 'logo': 'https://image.tmdb.org/t/p/original/qNVZUR6koKFlOFdycB0D9cewBEm.jpg', 'priority': 9},
		{'name': 'Spamflix', 'id': 521, 'logo': 'https://image.tmdb.org/t/p/original/xN97FFkFAdY1JvHhS4zyPD4URgD.jpg', 'priority': 9},
		{'name': 'Cultpix', 'id': 692, 'logo': 'https://image.tmdb.org/t/p/original/59azlQKUgFdYq6QI5QEAxIeecyL.jpg', 'priority': 9},
		{'name': 'DOCSVILLE', 'id': 475, 'logo': 'https://image.tmdb.org/t/p/original/bvcdVO7SDHKEa6D40g1jntXKNj.jpg', 'priority': 10},
		{'name': 'Peacock', 'id': 386, 'logo': 'https://image.tmdb.org/t/p/original/8VCV78prwd9QzZnEm0ReO6bERDa.jpg', 'priority': 11},
		{'name': 'VIX ', 'id': 457, 'logo': 'https://image.tmdb.org/t/p/original/58aUMVWJRolhWpi4aJCkGHwfKdg.jpg', 'priority': 11},
		{'name': 'FilmBox+', 'id': 701, 'logo': 'https://image.tmdb.org/t/p/original/4FqTBYsUSZgS9z9UGKgxSDBbtc8.jpg', 'priority': 11},
		{'name': 'Peacock Premium', 'id': 387, 'logo': 'https://image.tmdb.org/t/p/original/xTHltMrZPAJFLQ6qyCBjAnXSmZt.jpg', 'priority': 12},
		{'name': 'aha', 'id': 532, 'logo': 'https://image.tmdb.org/t/p/original/m3NWxxR23l1w1e156fyTuw931gx.jpg', 'priority': 12},
		{'name': 'Amazon Video', 'id': 10, 'logo': 'https://image.tmdb.org/t/p/original/5NyLm42TmCqCMOZFvH4fcoSNKEW.jpg', 'priority': 13},
		{'name': 'Kocowa', 'id': 464, 'logo': 'https://image.tmdb.org/t/p/original/xfAAOAERZCnPB5jW5lhboAcXk8L.jpg', 'priority': 13},
		{'name': 'WOW Presents Plus', 'id': 546, 'logo': 'https://image.tmdb.org/t/p/original/mgD0T960hnYU4gBxbPPBrcDfgWg.jpg', 'priority': 13},
		{'name': 'Takflix', 'id': 1771, 'logo': 'https://image.tmdb.org/t/p/original/cnIHBy3uLWhHRR7VeWQhK3ZsYP0.jpg', 'priority': 14},
		{'name': 'Crunchyroll', 'id': 283, 'logo': 'https://image.tmdb.org/t/p/original/8Gt1iClBlzTeQs8WQm8UrCoIxnQ.jpg', 'priority': 15},
		{'name': 'YouTube', 'id': 192, 'logo': 'https://image.tmdb.org/t/p/original/oIkQkEkwfmcG7IGpRR1NB8frZZM.jpg', 'priority': 15},
		{'name': 'Magellan TV', 'id': 551, 'logo': 'https://image.tmdb.org/t/p/original/gekkP93StjYdiMAInViVmrnldNY.jpg', 'priority': 15},
		{'name': 'BroadwayHD', 'id': 554, 'logo': 'https://image.tmdb.org/t/p/original/xLu1rkZNOKuNnRNr70wySosfTBf.jpg', 'priority': 16},
		{'name': 'Paramount Plus Apple TV Channel ', 'id': 1853, 'logo': 'https://image.tmdb.org/t/p/original/9pdeflA0P1b8qlkeDA1oLfyvR06.jpg', 'priority': 17},
		{'name': 'Dekkoo', 'id': 444, 'logo': 'https://image.tmdb.org/t/p/original/u2H29LCxRzjZVUoZUQAHKm5P8Zc.jpg', 'priority': 17},
		{'name': 'Starz Apple TV Channel', 'id': 1855, 'logo': 'https://image.tmdb.org/t/p/original/hB24bAA8Y2ei6pbEGuCNdKUOjxI.jpg', 'priority': 18},
		{'name': 'Filmzie', 'id': 559, 'logo': 'https://image.tmdb.org/t/p/original/olmH7t5tEng8Yuq33KmvpvaaVIg.jpg', 'priority': 18},
		{'name': 'Showtime Apple TV Channel', 'id': 675, 'logo': 'https://image.tmdb.org/t/p/original/xVN3LKkOtCrlFT9mavhkx8SzMwV.jpg', 'priority': 19},
		{'name': 'True Story', 'id': 567, 'logo': 'https://image.tmdb.org/t/p/original/osREemsc9uUB2J8VTkQeAVk2fu9.jpg', 'priority': 19},
		{'name': 'AMC Plus Apple TV Channel ', 'id': 1854, 'logo': 'https://image.tmdb.org/t/p/original/yFgm7vxwKZ4jfXIlPizlgoba2yi.jpg', 'priority': 20},
		{'name': 'DocAlliance Films', 'id': 569, 'logo': 'https://image.tmdb.org/t/p/original/aQ1ritN00jXc7RAFfUoQKGAAfp7.jpg', 'priority': 20},
		{'name': 'Britbox Apple TV Channel ', 'id': 1852, 'logo': 'https://image.tmdb.org/t/p/original/cN85Wjk0FIFr3z6rbiimz10uWVo.jpg', 'priority': 21},
		{'name': 'Hoichoi', 'id': 315, 'logo': 'https://image.tmdb.org/t/p/original/d4vHcXY9rwnr763wQns2XJThclt.jpg', 'priority': 21},
		{'name': 'BritBox', 'id': 151, 'logo': 'https://image.tmdb.org/t/p/original/aGIS8maihUm60A3moKYD9gfYHYT.jpg', 'priority': 22},
		{'name': 'KoreaOnDemand', 'id': 575, 'logo': 'https://image.tmdb.org/t/p/original/uHv6Y4YSsr4cj7q4cBbAg7WXKEI.jpg', 'priority': 22},
		{'name': 'Paramount+ Amazon Channel', 'id': 582, 'logo': 'https://image.tmdb.org/t/p/original/3E0RkIEQrrGYazs63NMsn3XONT6.jpg', 'priority': 23},
		{'name': 'MGM Plus Amazon Channel', 'id': 583, 'logo': 'https://image.tmdb.org/t/p/original/hoqk74y8HTJTMWcVes1ZVwohCue.jpg', 'priority': 24},
		{'name': 'Pluto TV', 'id': 300, 'logo': 'https://image.tmdb.org/t/p/original/t6N57S17sdXRXmZDAkaGP0NHNG0.jpg', 'priority': 24},
		{'name': 'Rakuten Viki', 'id': 344, 'logo': 'https://image.tmdb.org/t/p/original/qjtOUIUnk4kRpcZmaddjqDHM0dR.jpg', 'priority': 24},
		{'name': 'Discovery Plus Amazon Channel', 'id': 584, 'logo': 'https://image.tmdb.org/t/p/original/a2OcajC4bM5ItniQdjyOV7tgthW.jpg', 'priority': 25},
		{'name': 'iQIYI', 'id': 581, 'logo': 'https://image.tmdb.org/t/p/original/8MXYXzZGoPAEQU13GWk1GVvKNUS.jpg', 'priority': 25},
		{'name': 'Showtime Amazon Channel', 'id': 203, 'logo': 'https://image.tmdb.org/t/p/original/zoL69abPHiVC1Qzd4kM6hwLSo0j.jpg', 'priority': 26},
		{'name': 'AMC+ Amazon Channel', 'id': 528, 'logo': 'https://image.tmdb.org/t/p/original/9edKQczyuMmQM1yS520hgmJbcaC.jpg', 'priority': 27},
		{'name': 'Funimation Now', 'id': 269, 'logo': 'https://image.tmdb.org/t/p/original/fWq61Fy4onav0wZJTA3c2fs0G66.jpg', 'priority': 28},
		{'name': 'The Roku Channel', 'id': 207, 'logo': 'https://image.tmdb.org/t/p/original/z0h7mBHwm5KfMB2MKeoQDD2ngEZ.jpg', 'priority': 29},
		{'name': 'Showtime Roku Premium Channel', 'id': 632, 'logo': 'https://image.tmdb.org/t/p/original/qMf2zirM2w0sO0mdAIIoP5XnQn8.jpg', 'priority': 30},
		{'name': 'Paramount+ Roku Premium Channel', 'id': 633, 'logo': 'https://image.tmdb.org/t/p/original/qlVSrZgfXlFw0Jj6hsYq2zi70JD.jpg', 'priority': 31},
		{'name': 'Starz Roku Premium Channel', 'id': 634, 'logo': 'https://image.tmdb.org/t/p/original/5OAb2w7D9C2VHa0k5PaoAYeFYFE.jpg', 'priority': 32},
		{'name': 'Runtime', 'id': 1875, 'logo': 'https://image.tmdb.org/t/p/original/nvCfpn94VKJN4ZpkDgoupJWlXqq.jpg', 'priority': 32},
		{'name': 'AMC+ Roku Premium Channel', 'id': 635, 'logo': 'https://image.tmdb.org/t/p/original/ni2NgPmIqqJRXeiA8Zdj4UhBZnU.jpg', 'priority': 33},
		{'name': 'AMC+', 'id': 526, 'logo': 'https://image.tmdb.org/t/p/original/xlonQMSmhtA2HHwK3JKF9ghx7M8.jpg', 'priority': 34},
		{'name': 'MGM Plus Roku Premium Channel', 'id': 636, 'logo': 'https://image.tmdb.org/t/p/original/3sE2JNYZJRD9Le1P8B6oVEqarad.jpg', 'priority': 35},
		{'name': 'YouTube Premium', 'id': 188, 'logo': 'https://image.tmdb.org/t/p/original/6IPjvnYl6WWkIwN158qBFXCr2Ne.jpg', 'priority': 37},
		{'name': 'YouTube Free', 'id': 235, 'logo': 'https://image.tmdb.org/t/p/original/4SCmZgf7AeJLKKRPcbf5VFkGpBj.jpg', 'priority': 38},
		{'name': 'Hoopla', 'id': 212, 'logo': 'https://image.tmdb.org/t/p/original/aJ0b9BLU1Cvv5hIz9fEhKKc1x1D.jpg', 'priority': 39},
		{'name': 'The CW', 'id': 83, 'logo': 'https://image.tmdb.org/t/p/original/6Y6w3F5mYoRHCcNAG0ZD2AndLJ2.jpg', 'priority': 40},
		{'name': 'Vudu', 'id': 7, 'logo': 'https://image.tmdb.org/t/p/original/21dEscfO8n1tL35k4DANixhffsR.jpg', 'priority': 42},
		{'name': 'Starz', 'id': 43, 'logo': 'https://image.tmdb.org/t/p/original/eWp5LdR4p4uKL0wACBBXapDV2lB.jpg', 'priority': 43},
		{'name': 'VUDU Free', 'id': 332, 'logo': 'https://image.tmdb.org/t/p/original/xzfVRl1CgJPYa9dOoyVI3TDSQo2.jpg', 'priority': 44},
		{'name': 'Criterion Channel', 'id': 258, 'logo': 'https://image.tmdb.org/t/p/original/4TJTNWd2TT1kYj6ocUEsQc8WRgr.jpg', 'priority': 45},
		{'name': 'Showtime', 'id': 37, 'logo': 'https://image.tmdb.org/t/p/original/4kL33LoKd99YFIaSOoOPMQOSw1A.jpg', 'priority': 46},
		{'name': 'PBS', 'id': 209, 'logo': 'https://image.tmdb.org/t/p/original/bbxgdl6B5T75wJE713BiTCIBXyS.jpg', 'priority': 47},
		{'name': 'FXNow', 'id': 123, 'logo': 'https://image.tmdb.org/t/p/original/twV9iQPYeaoBzwsfRFGMGoMIUg8.jpg', 'priority': 48},
		{'name': 'Pantaflix', 'id': 177, 'logo': 'https://image.tmdb.org/t/p/original/2tAjxjo1n3H7fsXqMsxWFMeFUWp.jpg', 'priority': 49},
		{'name': 'Tubi TV', 'id': 73, 'logo': 'https://image.tmdb.org/t/p/original/w2TDH9TRI7pltf5LjN3vXzs7QbN.jpg', 'priority': 50},
		{'name': 'Kanopy', 'id': 191, 'logo': 'https://image.tmdb.org/t/p/original/wbCleYwRFpUtWcNi7BLP3E1f6VI.jpg', 'priority': 51},
		{'name': 'Comedy Central', 'id': 243, 'logo': 'https://image.tmdb.org/t/p/original/gmU9aPV3XUFusVs4kK1rcICUKqL.jpg', 'priority': 52},
		{'name': 'Microsoft Store', 'id': 68, 'logo': 'https://image.tmdb.org/t/p/original/shq88b09gTBYC4hA7K7MUL8Q4zP.jpg', 'priority': 53},
		{'name': 'Redbox', 'id': 279, 'logo': 'https://image.tmdb.org/t/p/original/gbyLHzl4eYP0oP9oJZ2oKbpkhND.jpg', 'priority': 54},
		{'name': 'ABC', 'id': 148, 'logo': 'https://image.tmdb.org/t/p/original/l9BRdAgQ3MkooOalsuu3yFQv2XP.jpg', 'priority': 56},
		{'name': 'Crackle', 'id': 12, 'logo': 'https://image.tmdb.org/t/p/original/7P2JHkfv4AmU2MgSPGaJ0z6nNLG.jpg', 'priority': 57},
		{'name': 'DIRECTV', 'id': 358, 'logo': 'https://image.tmdb.org/t/p/original/xL9SUR63qrEjFZAhtsipskeAMR7.jpg', 'priority': 58},
		{'name': 'Fandor', 'id': 25, 'logo': 'https://image.tmdb.org/t/p/original/eAhAUvV2ouai3cGti5y70YOtrBN.jpg', 'priority': 61},
		{'name': 'MGM Plus', 'id': 34, 'logo': 'https://image.tmdb.org/t/p/original/6A1gRIJqLfFHOoTvbTxDAbuU2nQ.jpg', 'priority': 64},
		{'name': 'Freeform', 'id': 211, 'logo': 'https://image.tmdb.org/t/p/original/rgpmwMkXqFYch9cway9qWMw0uXu.jpg', 'priority': 65},
		{'name': 'Syfy', 'id': 215, 'logo': 'https://image.tmdb.org/t/p/original/f7iqKjWYdVoYVIvKP3nboULcrM2.jpg', 'priority': 68},
		{'name': 'Lifetime', 'id': 157, 'logo': 'https://image.tmdb.org/t/p/original/3wJNOOCbvqi7fJAdgf1QpL7Wwe2.jpg', 'priority': 69},
		{'name': 'realeyz', 'id': 14, 'logo': 'https://image.tmdb.org/t/p/original/10BQc1kYmgjXFrFKb3xsRcDDn14.jpg', 'priority': 70},
		{'name': 'Shudder', 'id': 99, 'logo': 'https://image.tmdb.org/t/p/original/pheENW1BxlexXX1CKJ4GyWudyMA.jpg', 'priority': 71},
		{'name': 'Screambox', 'id': 185, 'logo': 'https://image.tmdb.org/t/p/original/c2Ey5Q3uUjZgfWWQQIdVIjVfxE4.jpg', 'priority': 72},
		{'name': 'Acorn TV', 'id': 87, 'logo': 'https://image.tmdb.org/t/p/original/5P99DkK1jVs95KcE8bYG9MBtGQ.jpg', 'priority': 73},
		{'name': 'Sundance Now', 'id': 143, 'logo': 'https://image.tmdb.org/t/p/original/pZ9TSk3wlRYwiwwRxTsQJ7t2but.jpg', 'priority': 74},
		{'name': 'Popcornflix', 'id': 241, 'logo': 'https://image.tmdb.org/t/p/original/olvOut34aWUFf1YoOqiqtjidiTK.jpg', 'priority': 75},
		{'name': 'Pantaya', 'id': 247, 'logo': 'https://image.tmdb.org/t/p/original/94IdHexespnJs96kmGiJlflfiwU.jpg', 'priority': 80},
		{'name': 'Boomerang', 'id': 248, 'logo': 'https://image.tmdb.org/t/p/original/oRXiHzPl2HJMXXFR4eebsb8F5Oc.jpg', 'priority': 81},
		{'name': 'Urban Movie Channel', 'id': 251, 'logo': 'https://image.tmdb.org/t/p/original/5uTsmZnDQmIOjZPEv8TNTy7GRJB.jpg', 'priority': 82},
		{'name': 'Dove Channel', 'id': 254, 'logo': 'https://image.tmdb.org/t/p/original/cBCzPOX6ir5L8hCoJlfIWycxauh.jpg', 'priority': 83},
		{'name': 'History Vault', 'id': 268, 'logo': 'https://image.tmdb.org/t/p/original/3bm7P1O8WRqK6CYqfffJv4fba2p.jpg', 'priority': 84},
		{'name': 'Nickhits Amazon Channel', 'id': 261, 'logo': 'https://image.tmdb.org/t/p/original/oMwjMgYiT2jcR7ELqCH3TPzpgTX.jpg', 'priority': 84},
		{'name': 'Eros Now', 'id': 218, 'logo': 'https://image.tmdb.org/t/p/original/4XYI2rzRm34skcvamytegQx7Dmu.jpg', 'priority': 85},
		{'name': 'Yupp TV', 'id': 255, 'logo': 'https://image.tmdb.org/t/p/original/8qNJcPBHZ4qewHrDJ7C7s2DBQ3V.jpg', 'priority': 86},
		{'name': 'Magnolia Selects', 'id': 259, 'logo': 'https://image.tmdb.org/t/p/original/foT1TtL67MgEOWR6Cib8dKyCvJI.jpg', 'priority': 88},
		{'name': 'WWE Network', 'id': 260, 'logo': 'https://image.tmdb.org/t/p/original/rDYZ9v3Y09fuFyan51tHKE1mFId.jpg', 'priority': 89},
		{'name': 'Noggin Amazon Channel', 'id': 262, 'logo': 'https://image.tmdb.org/t/p/original/yxBUPUBFzHE72uFXvFr1l0fnMJA.jpg', 'priority': 90},
		{'name': 'Smithsonian Channel', 'id': 276, 'logo': 'https://image.tmdb.org/t/p/original/UAZ2lJBWszijybQD4frqw2jxRO.jpg', 'priority': 91},
		{'name': 'Laugh Out Loud', 'id': 275, 'logo': 'https://image.tmdb.org/t/p/original/w4GTJ1EDrgJku49XKSnRag9kKCT.jpg', 'priority': 93},
		{'name': 'Hallmark Movies', 'id': 281, 'logo': 'https://image.tmdb.org/t/p/original/llEJ6av9kAniTQUR9hF9mhVbzlB.jpg', 'priority': 94},
		{'name': 'Pure Flix', 'id': 278, 'logo': 'https://image.tmdb.org/t/p/original/orsVBNvPWxJNOVSEHMOk2h8R1wA.jpg', 'priority': 95},
		{'name': 'Boomerang Amazon Channel', 'id': 288, 'logo': 'https://image.tmdb.org/t/p/original/1zfRJQc14uEzZThdwNvxtxeWJw6.jpg', 'priority': 96},
		{'name': 'PBS Kids Amazon Channel', 'id': 293, 'logo': 'https://image.tmdb.org/t/p/original/tU4tamrqRjbg3Lbmkryp3EiLPQJ.jpg', 'priority': 97},
		{'name': 'Lifetime Movie Club', 'id': 284, 'logo': 'https://image.tmdb.org/t/p/original/p1v0UKH13xQsMjumRgCGmCdlgKm.jpg', 'priority': 98},
		{'name': 'Cinemax Amazon Channel', 'id': 289, 'logo': 'https://image.tmdb.org/t/p/original/kEnyHRflZPNWEOIXroZPhfdGi46.jpg', 'priority': 99},
		{'name': 'Hallmark Movies Now Amazon Channel', 'id': 290, 'logo': 'https://image.tmdb.org/t/p/original/6L2wLiZz3IG2X4MRbdRlGLgftMK.jpg', 'priority': 101},
		{'name': 'PBS Masterpiece Amazon Channel', 'id': 294, 'logo': 'https://image.tmdb.org/t/p/original/mMALQK52OFGoYUKOSCZILZkfGWs.jpg', 'priority': 102},
		{'name': 'MZ Choice Amazon Channel', 'id': 291, 'logo': 'https://image.tmdb.org/t/p/original/72tiOIjZQPqm7MGhqoqyjyTJzSv.jpg', 'priority': 103},
		{'name': 'Viewster Amazon Channel', 'id': 295, 'logo': 'https://image.tmdb.org/t/p/original/mlH42JbZMrapSF6zc8iTYURcZlH.jpg', 'priority': 104},
		{'name': 'Sling TV Orange and Blue', 'id': 299, 'logo': 'https://image.tmdb.org/t/p/original/tZ4xzOtCRHjAw7tYJphivEfDr1L.jpg', 'priority': 105},
		{'name': 'HiDive', 'id': 430, 'logo': 'https://image.tmdb.org/t/p/original/9baY98ZKyDaNArp1H9fAWqiR3Zi.jpg', 'priority': 108},
		{'name': 'Topic', 'id': 454, 'logo': 'https://image.tmdb.org/t/p/original/ubWucXFn34TrVlJBaJFgPaC4tOP.jpg', 'priority': 110},
		{'name': 'Night Flight Plus', 'id': 455, 'logo': 'https://image.tmdb.org/t/p/original/ba8l0e5CkpVnrdFgzBySP7ckZnZ.jpg', 'priority': 111},
		{'name': 'Retrocrush', 'id': 446, 'logo': 'https://image.tmdb.org/t/p/original/9ONs8SMAXtkiyaEIKATTpbwckx8.jpg', 'priority': 113},
		{'name': 'Shout! Factory TV', 'id': 439, 'logo': 'https://image.tmdb.org/t/p/original/ju3T8MFGNIoPiYpwHFpNlrYNyG7.jpg', 'priority': 116},
		{'name': 'Chai Flicks', 'id': 438, 'logo': 'https://image.tmdb.org/t/p/original/3tCqvc5hPm5nl8Hm8o2koDRZlPo.jpg', 'priority': 117},
		{'name': 'OVID', 'id': 433, 'logo': 'https://image.tmdb.org/t/p/original/nXi2nRDPMNivJyFOifEa2t15Xuu.jpg', 'priority': 118},
		{'name': 'The Film Detective', 'id': 470, 'logo': 'https://image.tmdb.org/t/p/original/rOwEnT8oDSTZ5rDKmyaa3O4gUnc.jpg', 'priority': 120},
		{'name': 'Shudder Amazon Channel', 'id': 204, 'logo': 'https://image.tmdb.org/t/p/original/sc5pTTCFbx7GQyOst5SG4U7nkPH.jpg', 'priority': 122},
		{'name': 'MUBI Amazon Channel', 'id': 201, 'logo': 'https://image.tmdb.org/t/p/original/aJUiN18NZFbpSkHZQV1C1cTpz8H.jpg', 'priority': 123},
		{'name': 'BritBox Amazon Channel', 'id': 197, 'logo': 'https://image.tmdb.org/t/p/original/xTfyFZqWv8c8sxlFooUzemi6WRM.jpg', 'priority': 124},
		{'name': 'AcornTV Amazon Channel', 'id': 196, 'logo': 'https://image.tmdb.org/t/p/original/8WWD7t5Irwq9kAH4rufQ4Pe1Dog.jpg', 'priority': 125},
		{'name': 'Fandor Amazon Channel', 'id': 199, 'logo': 'https://image.tmdb.org/t/p/original/8vBJZkwkrUDYMSfmw5R0ZENd7yw.jpg', 'priority': 126},
		{'name': 'Screambox Amazon Channel', 'id': 202, 'logo': 'https://image.tmdb.org/t/p/original/naqM14qSfg2q0S2zDylM5zQQ3jn.jpg', 'priority': 127},
		{'name': 'USA Network', 'id': 322, 'logo': 'https://image.tmdb.org/t/p/original/ldU2RCgdvkcSEBWWbttCpVO450z.jpg', 'priority': 131},
		{'name': 'Bet+ Amazon Channel', 'id': 343, 'logo': 'https://image.tmdb.org/t/p/original/obBJU4ak4XvAOUM5iVmSUxDvqC3.jpg', 'priority': 133},
		{'name': 'FlixFling', 'id': 331, 'logo': 'https://image.tmdb.org/t/p/original/4U02VrbgLfUKJAUCHKzxWFtnPx4.jpg', 'priority': 134},
		{'name': 'Darkmatter TV', 'id': 355, 'logo': 'https://image.tmdb.org/t/p/original/x4AFz5koB2R8BRn8WNh6EqXUGHc.jpg', 'priority': 136},
		{'name': 'AMC on Demand', 'id': 352, 'logo': 'https://image.tmdb.org/t/p/original/kJlVJLgbNPvKDYC0YMp3yA2OKq2.jpg', 'priority': 137},
		{'name': 'TCM', 'id': 361, 'logo': 'https://image.tmdb.org/t/p/original/8TbsXATKVD4Humjzi6a8SVaSY7o.jpg', 'priority': 138},
		{'name': 'TNT', 'id': 363, 'logo': 'https://image.tmdb.org/t/p/original/gJnQ40Z6T7HyY6fbmmI6qKE0zmK.jpg', 'priority': 140},
		{'name': 'BBC America', 'id': 397, 'logo': 'https://image.tmdb.org/t/p/original/ukSXbR5qFjO2qCHpc6ZhcGPSjTJ.jpg', 'priority': 142},
		{'name': 'IndieFlix', 'id': 368, 'logo': 'https://image.tmdb.org/t/p/original/2NRn6OApVKfDTKLuHDRN8UadLRw.jpg', 'priority': 143},
		{'name': 'Here TV', 'id': 417, 'logo': 'https://image.tmdb.org/t/p/original/sa10pK4Jwr5aA7rvafFP2zyLFjh.jpg', 'priority': 158},
		{'name': 'Flix Premiere', 'id': 432, 'logo': 'https://image.tmdb.org/t/p/original/6fX0J6x7zXsUCvPFczgOW4oD34D.jpg', 'priority': 163},
		{'name': 'TBS', 'id': 506, 'logo': 'https://image.tmdb.org/t/p/original/rcebVnRvZvPXauK4353Jgiu4DWI.jpg', 'priority': 164},
		{'name': 'AsianCrush', 'id': 514, 'logo': 'https://image.tmdb.org/t/p/original/3VxDqUk25KU5860XxHKwV9cy3L8.jpg', 'priority': 165},
		{'name': 'FILMRISE', 'id': 471, 'logo': 'https://image.tmdb.org/t/p/original/mEiBVz62M9j3TCebmOspMfqkIn.jpg', 'priority': 166},
		{'name': 'Revry', 'id': 473, 'logo': 'https://image.tmdb.org/t/p/original/r1UgUKmt83FSDOIHBdRWKooZPNx.jpg', 'priority': 167},
		{'name': 'Spectrum On Demand', 'id': 486, 'logo': 'https://image.tmdb.org/t/p/original/79mRAYq40lcYiXkQm6N7YErSSHd.jpg', 'priority': 171},
		{'name': 'VRV', 'id': 504, 'logo': 'https://image.tmdb.org/t/p/original/rtTqPKRrVVXxvPV0T9OmSXhwXnY.jpg', 'priority': 172},
		{'name': 'Hi-YAH', 'id': 503, 'logo': 'https://image.tmdb.org/t/p/original/mB2eDIncwSAlyl8WAtfV24qEIkk.jpg', 'priority': 173},
		{'name': 'tru TV', 'id': 507, 'logo': 'https://image.tmdb.org/t/p/original/pg4bIFyUsSIhFChqOz5Up1BxuIU.jpg', 'priority': 174},
		{'name': 'Discovery Plus', 'id': 520, 'logo': 'https://image.tmdb.org/t/p/original/wYRiUqIgWcfUvO6OPcXuUNd4tc2.jpg', 'priority': 177},
		{'name': 'ARROW', 'id': 529, 'logo': 'https://image.tmdb.org/t/p/original/4UfmxLzph9Aso9pr9bXohp0V3sr.jpg', 'priority': 179},
		{'name': 'Plex', 'id': 538, 'logo': 'https://image.tmdb.org/t/p/original/wDWvnupneMbY6RhBTHQC9zU0SCX.jpg', 'priority': 180},
		{'name': 'Alamo on Demand', 'id': 547, 'logo': 'https://image.tmdb.org/t/p/original/1UP7ysjKolfD0rmp2fLmvyRHkdn.jpg', 'priority': 182},
		{'name': 'Dogwoof On Demand', 'id': 536, 'logo': 'https://image.tmdb.org/t/p/original/9sk88OAxDZSdMOzg8VuqtGpgWQ3.jpg', 'priority': 187},
		{'name': 'MovieSaints', 'id': 562, 'logo': 'https://image.tmdb.org/t/p/original/fdWE8jpmQqkZrwg2ZMuCLz6ms5P.jpg', 'priority': 188},
		{'name': 'Film Movement Plus', 'id': 579, 'logo': 'https://image.tmdb.org/t/p/original/tKJdVrC0fjEtQtYYjlVwX9rmqrj.jpg', 'priority': 195},
		{'name': 'Metrograph', 'id': 585, 'logo': 'https://image.tmdb.org/t/p/original/8PmpsrVDLJ3m8I37W6UNFEymhm7.jpg', 'priority': 197},
		{'name': 'Freevee', 'id': 613, 'logo': 'https://image.tmdb.org/t/p/original/uBE4RMH15mrkuz6vXzuJc7ZLXp1.jpg', 'priority': 198},
		{'name': 'Kino Now', 'id': 640, 'logo': 'https://image.tmdb.org/t/p/original/ttxbDVmHMuNTKcSLOyIHFs7TdRh.jpg', 'priority': 200},
		{'name': 'ShortsTV Amazon Channel', 'id': 688, 'logo': 'https://image.tmdb.org/t/p/original/m0mvKlSjn38S9w7WVNV7a7XyPIe.jpg', 'priority': 205},
		{'name': 'Bet+', 'id': 1759, 'logo': 'https://image.tmdb.org/t/p/original/eZVDDqlBHpuk8GELhQchRIkA6th.jpg', 'priority': 208},
		{'name': 'ESPN Plus', 'id': 1768, 'logo': 'https://image.tmdb.org/t/p/original/iJBj5b4HYbjEPiwKJWQfcRr3nP2.jpg', 'priority': 214},
		{'name': 'Paramount+ Showtime', 'id': 1770, 'logo': 'https://image.tmdb.org/t/p/original/vfUoancVnPRAxj8iBqhllanF0Eq.jpg', 'priority': 216},
		{'name': 'Klassiki', 'id': 1793, 'logo': 'https://image.tmdb.org/t/p/original/fXGdolQR7QlHgdx2hPCxoVQG8eP.jpg', 'priority': 223},
		{'name': 'Starz Amazon Channel', 'id': 1794, 'logo': 'https://image.tmdb.org/t/p/original/x36C6aseF5l4uX99Kpse9dbPwBo.jpg', 'priority': 224},
		{'name': 'Netflix basic with Ads', 'id': 1796, 'logo': 'https://image.tmdb.org/t/p/original/mShqQVDhHoK7VUbfYG3Un6xE8Mv.jpg', 'priority': 225},
		{'name': 'Cohen Media Amazon Channel', 'id': 1811, 'logo': 'https://image.tmdb.org/t/p/original/jV7sSPzUYYHHmoATkD9PhFoEZXb.jpg', 'priority': 230},
		{'name': 'Popflick', 'id': 1832, 'logo': 'https://image.tmdb.org/t/p/original/wbKHI2d5417yAAY7QestC3qnXyo.jpg', 'priority': 233},
		{'name': 'Viaplay', 'id': 76, 'logo': 'https://image.tmdb.org/t/p/original/cvl65OJnz14LUlC3yGK1KHj8UYs.jpg', 'priority': 236}
	]