# -*- coding: utf-8 -*-

'''
 ***********************************************************
 * The Crew Add-on
 *
 *
 * @file trailer.py
 * @package script.module.thecrew
 *
 * @copyright (c) 2023, The Crew
 * @license GNU General Public License, version 3 (GPL-3.0)
 *
 ********************************************************cm*
'''

import sys
import simplejson as json
import re
import six
import time

from six.moves import urllib_parse
from resources.lib.modules import client
from resources.lib.modules import control
from resources.lib.modules import log_utils


class trailer:
    def __init__(self):
        try:
            self.base_link = 'https://www.youtube.com'
            self.base_link2 = 'https://youtube.com'
            self.base_link3 = 'https://youtu.be'

            #cm - not as nice as i want to
            self.url = ''

            self.is_youtube_link = 'true' if 'youtu' in self.url else 'false'

            self.key = control.addon('plugin.video.youtube').getSetting('youtube.api.key');
            # if not self.key and self.is_youtube_link == 'false':
            #     control.infoDialog(control.lang(32362), sound=True, icon='WARNING')
            # else:
            self.key_link = '&key=%s' % self.key
            self.search_link = 'https://www.googleapis.com/youtube/v3/search?part=id&type=video&maxResults=5&q=%s' + self.key_link
            self.youtube_watch = 'https://www.youtube.com/watch?v=%s'
        except:
            pass


    def play(self, name='', url='', meta='', windowedtrailer=0):
        try:
            #control.infoDialog('cm - url = ' + str(self.url), sound=False, icon='WARNING')
            url = self.worker(name, url, meta)
            if not url:
                return

            title = control.infoLabel('ListItem.Title')
            if not title: title = control.infoLabel('ListItem.Label')
            icon = control.infoLabel('ListItem.Icon')
 
            item = control.item(label=name, path=url)
            item.setArt({'icon': icon, 'thumb': icon, 'poster': icon})
            item.setInfo(type="video", infoLabels={"title": name})

            item.setProperty('IsPlayable','true')
            control.resolve(handle=int(sys.argv[1]), succeeded=True, listitem=item)
            if windowedtrailer == 1:
                # The call to the play() method is non-blocking. So we delay further script execution to keep the script alive at this spot.
                # Otherwise this script will continue and probably already be garbage collected by the time the trailer has ended.
                control.sleep(1000)  # Wait until playback starts. Less than 900ms is too short (on my box). Make it one second.
                while control.player.isPlayingVideo():
                    control.sleep(1000)
                # Close the dialog.
                # Same behaviour as the fullscreenvideo window when :
                # the media plays to the end,
                # or the user pressed one of X, ESC, or Backspace keys on the keyboard/remote to stop playback.
                control.execute("Dialog.Close(%s, true)" % control.getCurrentDialogId)
                self.url = ''
        except:
            pass
 
    def worker(self, name, url, meta):
        try:
            if url.startswith(self.base_link) or url.startswith(self.base_link2) or url.startswith(self.base_link3):
                url = self.resolve(url)
                if not url: raise Exception()
                return url
            elif not url.startswith('http'):
                url = self.youtube_watch % url
                url = self.resolve(url)
                if not url: raise Exception()
                return url
            else:
                raise Exception()
        except:
            query = 'Official trailer ' + name + ''
            query = self.search_link % urllib_parse.quote_plus(name)
            return self.search(query)
 
    def search(self, url):
        try:
            apiLang = control.apiLanguage().get('youtube', 'en')
 
            if apiLang != 'en': url += "&relevanceLanguage=%s" % apiLang

            result = client.request(url)
            result = control.six_decode(result)

            json_items = json.loads(result).get('items', [])
            items = [i.get('id', {}).get('videoId') for i in json_items]

            for vid_id in items:
                url = self.resolve(vid_id)
            if url:
                return url
        except:
            return
 
    def resolve(self, url, ):
        try:
            id = url.split('?v=')[-1].split('/')[-1].split('?')[0].split('&')[0]
            result = client.request(self.youtube_watch % id)


            message = client.parseDOM(result, 'div', attrs={'id': 'unavailable-submessage'})
            message = ''.join(message)
 
            alert = client.parseDOM(result, 'div', attrs={'id': 'watch7-notification-area'})
 
            if len(alert) > 0: raise Exception()
            if re.search('[a-zA-Z]', message): raise Exception()
 
            url = 'plugin://plugin.video.youtube/play/?video_id=%s' % id
            return url
        except:
            return