# Rules for Reporting Issues

* Earlier versions than **Kodi Matrix** are no longer supported.
* Please provide **FULL** details of your issue.

  ```
  Operating System: Android/Windows/OSX, etc...
  Device: Nvidia Shield/FireTV, etc...
  Version of Kodi: 19.0/19.1, etc...
  Version of chainsgenocide add-on: 6.3.0/6.4.9, etc...
  Country: USA/Australia/UK, etc..
  Debrid services in use: Real-Debrid/Premiumize/AllDebrid.
  ```
  What not to do:

      DO NOT state things like "no streams available" when searching "Game of Thrones".
      How am I to test without knowing the "season" and "episode" you are having an issue with?
  What is best practice:

      Post screenshots of the issue!  The more the merrier.
      The more detail you can provide of the condition, without me asking for additional info,  the faster I can trace it.


* **ALL** error related Issues opened **MUST** include log files. Please provide both the **Kodi debug** log as well as the **chainsgenocide** log file.
* Please review Open Issues to see if your problem is being addressed already.
* **Do Not** hijack an open issue with unrelated problems. Please open a new issue.
* I am not a fan of hearing **Well this addon works and yours does not**.  I often find that insulting and would just assume delete your issue and tell you to use that addon.  I'm not into addon comparison games when the code base is more often not interchangeable to begin with.

* If I've requested additional info for your issue it is your job to monitor the issue. I'll delete posts after an extended period of no response.

* If your issue is service related outside of chainsgenocide, please wait at least **24hrs** before opening an issue. Services go down for maintenance and I do not desire to spend my time chasing this to respond back to you with **Real-Debrid is down for maintenance**.
* Please learn to cross check the meta providers before posting an issue.  Posting things like **episodes missing** from **Brooklyn Nine Nine** when **TVDb** shows an additional episode for Season 8 and **TMDb** does not is counter productive.  **chainsgenocide** indexes the meta from **TMDb** so what they offer is what we will see.  I cannot, and will not manipluate this provided meta in any form of a workaround.
* I do not have the luxury of free time to devote playing Kodi teacher.  If you do not understand how to post a log, cross check gui meta vs. meta provider sites, find a specific setting category, understand basic Kodi terminolgy..like you do not know the difference between the terms "scrape" vs. "search" then you need to google search and do some reading first.
